﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using Microsoft.Xna.Framework;
using CashierCrisis.Entities;
using CashierCrisis.Core;

namespace CashierCrisis.Behaviors
{
    public delegate void BehaviorDelegateFinished(Status status);

    [XmlRoot("Node")]
    public abstract class Behavior : IVisitable
    {
        [XmlIgnore]
        public Behavior Parent { get; set; }
        
       // [XmlIgnore]
       // public virtual Entity Entity { get; set; }
        
        [XmlIgnore]
        public Status CurrentStatus { get; set; }

        [XmlIgnore]
        public bool IsRoot
        {
            get { return (Parent == null); }
        }

        [XmlIgnore]
        public Behavior Root
        {
            get
            {
                if (IsRoot)
                {
                    return this;
                }

                Behavior ancestor = Parent;

                while (ancestor.Parent != null)
                {
                    ancestor = ancestor.Parent;
                }

                return ancestor;
            }
        }

        public virtual Status Execute(GameTime gameTime)
        {
            return Failed;
        }

        public virtual Behavior Add(Behavior behavior)
        {
            throw new NotImplementedException("Adding Behaviors not supported");
        }

        public virtual void Attach(Behavior behavior)
        {
            if (behavior == null)
            {
                throw new NullReferenceException("Child behaviors cannot be null");
            }
        }

        public virtual void Init()
        {
            return;
        }

        #region Return Properties
        protected Status Inactive
        {
            get 
            {
                CurrentStatus = Status.Inactive;
                return Status.Inactive; 
            }
        }

        protected Status Completed
        {
            get 
            {
                CurrentStatus = Status.Completed;
                return Status.Completed; 
            }
        }

        protected Status Failed
        {
            get
            {
                CurrentStatus = Status.Failed;
                return Status.Failed; 
            }
        }

        protected Status Running
        {
            get 
            {
                CurrentStatus = Status.Running;
                return Status.Running; 
            }
        }
        #endregion

        #region IVisitable Members

        public void Accept(IVisitor visitor)
        {
            visitor.Visit(this);
        }

        #endregion
    }
}
